<?php

namespace app\api\controller;

use app\common\controller\Api;

/**
 * 意见反馈接口
 */
class Feedback extends Api
{

    // 无需登录的接口,*表示全部
    protected $noNeedLogin = [''];
    // 无需鉴权的接口,*表示全部
    protected $noNeedRight = ['*'];

    /**
     * 添加反馈
     *
     * @return void
     * @author AriFe.Liu 
     */
    public function add(){
        $type = $this->request->param('type','default');
        $content = $this->request->param('content');
        if(!$content) $this->error('请填写反馈内容');
        $tel = $this->request->param('tel');
        if(!$tel) $this->error('请填写联系方式');
        $nickname = $this->request->param('nickname','');

        $res = db('Feedback')->insert([
            'type' => $type,
            'user_id' => $this->auth->id,
            'content' => $content,
            'tel' => $tel,
            'createtime' => time(),
            'nickname' => $this->auth->nickname
        ]);

        if(!$res) $this->error('反馈失败,请稍后再试');
        $this->success('ok');


    }

}
